//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-12: Compressible Flow  
//Example 12.1  Page 670
//Title: Compression of High-Speed Air in an Aircraft

package Ex12_1
model Ex12_1_a

//=================
//Parameter Section
parameter Real T1(unit = "K") = 255.7 "Ambient air temperature";
parameter Real V1(unit = "m/s") = 250 "Cruising speed of aircraft";
parameter Real Cp(unit = "kJ/kg K") = 1.005 "Specific heat of air room temperature";
parameter Real k(unit = "-") = 1.4 "Specific heat ratio of air at room temperature";
parameter Real P1(unit = "kPa") = 54.05 "Atmospheric pressure";

//=================
//Variable Section 
Real T01(unit = "K") "Stagnation temperature at the compressor inlet";
Real P01(unit = "kPa") "Stagnation pressure at the compressor inlet";

//=================
//Equation Section 
equation 
T01 = T1 + (V1^2/(2*Cp))*(1/1000); 

//Reduced form of ideal-gas isentropic relation since it is isentropic process 
P01 = (P1)*((T01/T1)^((k)/(k-1))); 
 

end Ex12_1_a;

//==================

model Ex12_1_b
extends Ex12_1_a;

//=================
//Parameter Section
parameter Real PR(unit = "-") = 8 "Stagnation pressure ratio across the compressor";

//=================
//Variable Section 
Real T02(unit = "K") "Stagnation temperature of air at the compressor exit";
Real P02(unit = "kPa") "Stagnation pressure of air at the compressor exit";
Real W_in(unit = "kJ/kg") "Work supplied to the compressor";

//=================
//Equation Section 
equation
P02/P01 = PR;
T02 = (T01)*((P02/P01)^((k-1)/(k)));
W_in = Cp*(T02-T01);

end Ex12_1_b;

//==================

end Ex12_1;

//==================
