//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-12: Compressible Flow  
//Example 12.16  Page 718
//Title: Exit Conditions of Fanno Flow in a Duct

model Ex12_16
extends Modelica.Constants;

//=================
//Parameter Section
parameter Real k(unit = "-") = 1.4 "Specific heat ratio of air";
parameter Real Cp(unit = "kJ/kg·K") = 1.005 "Specific heat capacity of air";
parameter Real R(unit = "kJ/kg·K") = 0.287 "Gas constant";
parameter Real T1(unit = "K") = 450 "Temperature at the inlet";
parameter Real P1(unit = "kPa") = 220 "Pressure at the inlet";
parameter Real f(unit = "-") = 0.023 "Average friction factor for the duct";
parameter Real V1(unit = "m/s") = 85 "Velocity of air at the inlet";
parameter Real D(unit = "cm") = 5 "Diameter of the duct";
parameter Real L(unit = "m") = 27 "Length of the duct";

//=================
//Variable Section 
Real c1(unit = "m/s") "Speed of air";
Real Ma1(unit = "-") "Mach number";
Real F_calc(unit = "-") "Function obtained using actual duct length";
Real F_act1(unit = "-") "Function obtained from table";
Real F_act2(unit = "-") "Function obtained from calculation at the duct exit";
Real Ma2(unit = "-") "Mach number at the duct exit";
Real Rho1(unit = "kg/m3") "Density of air";
Real m_air(unit = "kg/s") "Mass flow rate of air";
Real A1(unit = "m2") "Area of the duct";
String Analysis;

//=================
//Equation Section 
equation 
c1 = sqrt(k*R*T1*1000);
Ma1 = V1/c1;

//Corresponding to Ma 1 from Table A-16, Page No.964
F_act1 = 14.5333; //F_act1 = (f*L/D)

F_calc = (f*L)/(D*0.01); 
//D Multiplied by 0.01 to convert cm to m

//Flow Condition Check
if F_calc < F_act1 then 
Analysis = "Flow is not choked and the exit Mach number is less than 1";
else 
Analysis = "Flow is choked";
end if;
Modelica.Utilities.Streams.print(Analysis);

F_act2 = F_act1-F_calc;

//Corresponding to F_act2 from Table A-16;
Ma2 = 0.420; 

Rho1 = P1/(R*T1);
A1 = (pi/4)*(D*0.01)^2;
//Multiplying D by 0.01 to convert cm to m

m_air = Rho1*A1*V1;

end Ex12_16;
//==================
