//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-12: Compressible Flow  
//Example 12.4  Page 680
//Title: Isentropic Flow of Air in a Nozzle

model Ex12_4

//=================
//Parameter Section
parameter Real Ti(unit = "R") = 630 "Temperature of air at the entrance of the nozzle";
parameter Real Pi(unit = "psia") = 30 "Pressure of air at the inlet";
parameter Real k(unit = "-") = 1.4 "Specific heat ratio of air";
parameter Real Cp(unit = "Btu/lbm·R") = 0.240 "Specific heat capacity of air";
                                     //From Table A–1E, Page no-966
parameter Real Ma(unit = "-") = 1 ;
parameter Real V_i(unit = "ft/s") = 450 "Velocity of air";
parameter Real R(unit = "Btu/lbm·R") = 0.06855 "Gas constant";

parameter Real T_R(unit = "-") = 0.8333 "Temperature ratio"; 
//T_R = T/T0, From Table 12-2, Page no-677 or Table A-13, Page no-961

parameter Real P_R(unit = "-") = 0.5283 "Pressure ratio" ;
//P_R = P/P0, From Table 12-2, Page no-677 or Table A-13, Page no-961

parameter Real RA(unit = "-") = 1.7426 "Area ratio"; 
//RA = Ai/A* (Nozzle inlet to Throat area), From Table A-13, Page no-961


//=================
//Variable Section 
Real T0(unit = "R") "Stagnation temperature";
Real P0(unit = "psia") "Stagnation pressure";
Real ci(unit = "ft/s") "Speed of sound";
Real Ma_i(unit = "-") "Mach number at the inlet";
Real T(unit = "R") "Exit temperature";
Real P(unit = "psia") "Exit pressure";
Real AR(unit = "-") "Ratio of the throat area to the nozzle inlet area ";

//=================
//Equation Section 
equation 
T0 = Ti + (((V_i^2)/(2*Cp*25037)));
P0 = Pi*((T0/Ti)^((k)/(k-1)));
T = T_R*T0;
P = P_R*P0;

ci = sqrt(k*R*Ti*25037);
//Multiplying by 25037 to convert ci to ft/s

Ma_i = V_i/ci;
AR = 1/RA;

end Ex12_4;
//==================
