//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-12: Compressible Flow  
//Example 12.8  Page 690
//Title: Shock Wave in a Converging–Diverging Nozzle

package Ex12_8
model Ex12_8_a

//=================
//Parameter Section
//The fluid properties at the exit of the nozzle just before the shock (denoted by subscript 1) are those evaluated in Example 12–6 at the nozzle exit 

parameter Real P_01(unit = "MPa") = 1.0 "Pressure at the inlet of nozzle";
parameter Real P_1(unit = "MPa") = 0.1278 "Pressure at the exit of nozzle";
parameter Real T_1(unit = "K") = 444.5 "Pressure at the exit of nozzle";
parameter Real Rho_1(unit = "kg/m3") = 1.002 "Density of air at the exit of nozzle";
parameter Real Cp(unit = "kJ/kg·K") = 1.005 "Specific heat capacity";
parameter Real R(unit = "kJ/kg·K") = 0.287 "Gas constant";
parameter Real k(unit = "-") = 1.4 "Specific heat ratio of air";
parameter Real Rho_T(unit = "kg/m3") = 2.761 "Density of air at the throat";
parameter Real A_T(unit = "cm2") = 20 "Area of the throat";
parameter Real V_T(unit = "m/s") = 517.5 "Velocity of the air across the throat";

//For Ma = 2 Ratios are taken from Table A–14, Page no: 962
parameter Real Pi_R(unit = "-") = 0.7209 "Inlet Pressure ratio"; //Pi_R = P_02/P_01
parameter Real Po_R(unit = "-") = 4.5000"Exit Pressure ratio"; //Po_R = P_2/P_1
parameter Real T_R(unit = "-") = 1.6875 "Temperature ratio"; //T_R = T_2/T_1
parameter Real Rho_R(unit = "-") = 2.6667 "Density ratio"; //Rho_R = Rho_2/Rho_1
parameter Real Ma_2(unit = "-") = 0.5774 "Mach number after the shock";

//=================
//Variable Section 
//Fluid Properties after the shock
Real P_02(unit = "MPa") "Stagnation pressure";
Real P_2(unit = "MPa") "Static pressure";
Real T_2(unit = "K") "Static temperature";
Real Rho_2(unit = "kg/m3") "Static density";

//=================
//Equation Section 
equation 
P_02 = Pi_R*P_01;
P_2 = Po_R*P_1;
T_2 = T_R*T_1;
Rho_2 = Rho_R*Rho_1;

end Ex12_8_a;

//==================
model Ex12_8_b
extends Ex12_8_a;
extends Modelica.Math;

//=================
//Variable Section 
Real del_s(unit = "kJ/kg·K") "Entropy change across the shock";

//=================
//Equation Section 
equation 
del_s = (Cp*log(T_2/T_1))-(R*log(P_2/P_1));

//==================
end Ex12_8_b;

//==================

model Ex12_8_c
extends Ex12_8_a;

//=================
//Variable Section 
Real c_2(unit = "m/s") "Speed of sound at the exit conditions after the shock";
Real V_2(unit = "m/s") "Air velocity after the shock";

//=================
//Equation Section 
equation 
c_2 = sqrt(k*R*T_2*1000);
V_2 = Ma_2*c_2;

end Ex12_8_c;

//==================
model Ex12_8_d
extends Ex12_8_c;
extends Ex12_8_a;

//=================
//Variable Section 
Real m(unit = "kg/s") "Mass flow rate through the nozzle";

//=================
//Equation Section 
equation 
m = Rho_T*A_T*0.0001*V_T;
//Multiplying A_T by 0.0001 to convert cm2 to m2

end Ex12_8_d;

//==================

end Ex12_8;

//==================
