//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-13: Open-Channel Flow
//Example 13.2 Page 748
//Title: Flow Rate in Open Channel in Uniform Flow

model Ex13_2
extends Modelica.Constants;

//=================
//Parameter Section
parameter Real D(unit = "m") = 2 "Diameter of circular channel";
parameter Real S0(unit = "m/km") = 1.5 "Slope";

//From Table 13-1, Page No.747
parameter Real n(unit = "-") = 0.012 "Manning coefficient for an open channel of finished concrete";
parameter Real a(unit = "m^(1/3)/s") = 1 "Dimensional constant";

//=================
//Variable Section 
Real R(unit = "m") "Radius of circular channel";
Real A_c(unit = "m2") "Flow Area";
Real p(unit = "m") "Wetted perimeter";
Real R_h(unit = "m") "Hydraulic radius";
Real v(unit = "m3/s") "Flow rate of water";
Real P(unit = "m") "Perimeter";

//=================
//Equation Section 
equation 
R = D/2;
A_c = (pi*(R^2))/2;
p = (2*pi*R)/2;
P = pi*R;
R_h = A_c/P;

//Manning’s equation
v = (a/n)*A_c*((R_h)^(2/3))*((S0/1000)^(0.5));

end Ex13_2;
//==================
