//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-13: Open-Channel Flow
//Example 13.5 Page 754
//Title: Best Cross Section of an Open Channel

package Ex13_5
model Ex13_5_a

//=================
//Parameter Section
parameter Real v(unit = "m3/s") = 2 "Flow rate of water";
parameter Real S0(unit = "-") = 0.001 "Bottom slope";
parameter Real a(unit = "m^(1/3)/s") = 1 "Dimensional constant";
parameter Real n(unit = "-") = 0.016 " Manning coefficient for an open channel with asphalt lining";

//=================
//Variable Section 

//Rectangular channel
Real A_c1(unit = "m2") "Area of rectangle";
Real p_1(unit = "m") "Perimeter of rectangle";
Real b_1(unit = "m") "Width of rectangle";
Real y_1(unit = "m") "Flow height in rectangular channel";
Real h_R1(unit = "m") "Hydraulic radius rectangular channel";

//=================
//Equation Section 
equation 

//From manning equation
b_1 = ((2*n*v*(4^(2/3)))/(a*sqrt(S0)))^(3/8);
A_c1 = (b_1^2)/2;
p_1 = 2*b_1;
y_1 = A_c1/b_1;
h_R1 = b_1/4;

end Ex13_5_a;

//==================

model Ex13_5_b
extends Ex13_5_a;
extends Modelica.Math;
extends Modelica.Constants;

//=================
//Parameter Section
parameter Real theta(unit = "degree") = 60 "Trapezoid angle";

//=================
//Variable Section 

//Trapezoidal channel
Real A_c2(unit = "m2") "Area of trapezoid";
Real p_2(unit = "m") "Perimeter of trapezoid";
Real b_2(unit = "m") "Width of trapezoid";
Real y_2(unit = "m") "Flow height in Trapezoidal channel";
Real R_h2(unit = "m") "Hydraulic radius in Trapezoidal channel";
String Best_cross_section;

//=================
//Equation Section 
equation 

//From Manning equation
A_c2 = 0.5*sqrt(3*(b_2)^2)*(1+cos(theta*(pi/180)));
//Multiplying theta by (pi/180) to convert deg to rad

//Substituting into the Manning equation
b_2 = ((n*v)/((0.75*sqrt(3)*(((sqrt(3)/4))^(2/3)))*a*sqrt(S0)))^(3/8);
R_h2 = ((sqrt(3))/4)*b_2;
p_2 = 3*b_2;
y_2 = b_2*sqrt(3)/2;

//Determining the best cross section
if p_2<p_1 then
Best_cross_section = "Trapezoidal channel";
else
Best_cross_section = "Rectangular channel";
end if;

Modelica.Utilities.Streams.print(Best_cross_section);

end Ex13_5_b;

//==================

end Ex13_5;

//==================

