//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-14: Turbomachinery
//Example 14.16 Page 866
//Title: Turbine Specific Speed

model Ex14_16

//=================
//Parameter Section
//Small turbine - A , Large Turbine - B
parameter Real Rho_w(unit = "kg/m3") = 998 "Density of water at T = 20 C";
parameter Real g(unit = "m/s2") = 9.81 "Gravitational constant";

//From Ex14_15
parameter Real omega(unit = "rad/s") = 12.57 "Rotational speed";
parameter Real bhp_A(unit = "W") = 242*10^6 "Brake horse power of turbine A";
parameter Real bhp_B(unit = "W") = 548*10^6 "Brake horse power of turbine B";
parameter Real H_A(unit = "m") = 75 "Net head of turbine A";
parameter Real H_B(unit = "m") = 104 "Net head of turbine B";

//From Figure 14-120, Page No.867
parameter Real Cp(unit = "-") = 3.38 "Dimensionless parameter";
parameter Real CH(unit = "-") = 1.11 "Dimensionless parameter";

//=================
//Variable Section 
Real N_stA(unit = "-") "Dimensionless turbine specific speed for turbine A";
Real N_stB(unit = "-") "Dimensionless turbine specific speed for turbine B";
Real N_st(unit = "-") "Dimensionless turbine specific speed for turbine";
Real N_st_US(unit = "-") "Dimensionless turbine specific speed for turbine";
String Choice_of_Turbine;

//=================
//Equation Section 
equation
N_stA = (omega*(bhp_A^0.5))/((Rho_w^(1/2))*((g*H_A)^(5/4)));
N_stB = (omega*(bhp_B^0.5))/((Rho_w^(1/2))*((g*H_B)^(5/4)));

//Method - 2 : Check for N_st
N_st = (Cp^0.5)/(CH^(5/4));

//Turbine specific speed in customary U.S. units
N_st_US = 43.46*N_st;

//Choice of Turbine
if N_st<2 then
Choice_of_Turbine = "Francis Turbine";
else
Choice_of_Turbine = "Kaplan and Propeller";
end if;

Modelica.Utilities.Streams.print(Choice_of_Turbine);   

end Ex14_16;
//==================
