//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-2: Properties of Fluids  
//Example 2.1  Page 41
//Title:  Density, Specific Gravity, and Mass of Air in a Room

model Ex2_1

//=================
//Parameter Section
parameter Real l(unit = "m") = 4 "length of room";
parameter Real w(unit = "m") = 6 "width of room";
parameter Real h(unit = "m") = 5 "height of room";
parameter Real P(unit = "kPa") = 100 "Pressure";
parameter Real T(unit = "C") = 25 "Temperature";
parameter Real R(unit = "kPa m3/kg K") = 0.287 "Gas constant of air";
parameter Real Rho(unit = "kg/m3") = 1000 "Density of water";

//=================
//Variable Section 
Real SG(unit = "-") "Specific gravity of air";
Real Rho_a(unit = "kg/m3") "Density of air";
Real V(unit = "m3") "Volume of Room";
Real m(unit = "kg") "Mass of air in room";
Real T_c(unit = "K") "Converted Temperature from C to K";

//=================
//Equation Section 
equation 
T_c = T + 273.15;
Rho_a = (P/(R*T_c));
SG = Rho_a/Rho;
V = l*w*h;
m = Rho_a*V;

end Ex2_1;
//==================
