//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-2: Properties of Fluids  
//Example 2.7  Page 61 
//Title: Using Capillary Rise to Generate Power in a Hydraulic Turbine

model Ex2_7
extends Modelica.Constants;

//=================
//parameter Section
parameter Real h(unit = "cm") = 5 "Rise of Water";
parameter Real g(unit = "m/s2") = 9.81 "Gravitational constant";
parameter Real rho_w(unit = "kg/m3") = 1000 "Density of water";
parameter Real Pb(unit = "atm") = 1 "atmospheric pressure at the bottom";

//=================
//Variable Section 
Real del_P(unit = "kN/m2") "Pressure difference across the tube in kN/m2";
Real del_Pc(unit = "atm") "Pressure difference across the tube in atm";
String Result;

//=================
//Equation Section
equation 
del_P = (rho_w*g*(h*0.01))/1000; 
//Multiplying h by 0.01 to convert cm to m

del_Pc = del_P/100; 
//Dividing del_P by 100 to convert kN/m2 to atm
  
//Checking condition what happens if the hole is drilled at some elevation in the tube    
if del_Pc<Pb then
Result = "the top of the meniscus would fall";
else
Result = "the top of the meniscus does not fall";
end if;

Modelica.Utilities.Streams.print(Result);                      


end Ex2_7;
//=================
