//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-3: Pressure and Fluid Statics   
//Example 3.5  Page 86
//Title: Hydrostatic Pressure in a Solar Pond with Variable Density

model Ex3_5
extends Modelica.Math;
extends Modelica.Constants;

//=================
//Parameter Section
parameter Real g(unit = "m/s2") = 9.81 "Gravitational constant";
parameter Real Rho(unit = "kg/m3")= 1040 "Density of brine";
parameter Real h1(unit = "m")=0.8 "Thickness of surface zone";
parameter Real H(unit = "m")=4 "Thickness of gradient zone";
parameter Real s(unit = "m")=4 "Thickness of gradient zone";
parameter Real [8] s_array(each unit = "m") = {0.5,1,1.5,2,2.5,3,3.5,4}"Array of value for thickness of gradient zone";

//=================
//Variable Section 
Real P1(unit = "kPa") "The gage pressure at the bottom of the surface zone";
Real P2(unit = "kPa") "Pressure at the bottom of the gradient zone";
Real [8] P(each unit = "kPa") "Variation of gage pressure";

//=================
//Equation Section
equation 
P1=(Rho*g*h1)/1000;
P2=(P1+((Rho*g)*(4*H/pi)*asinh(tan(pi/4)*(s/H))/1000));
//P1 and P2 is divided by 1000 to convert Pa to kPa

//Data generated for Plotting 
//Variation of gage pressure in the gradient zone with depth
for i in 1:8 loop
P[i]=(P1+((Rho*g)*(4*H/pi)*asinh(tan(pi/4)*(s_array[i]/H))/1000));
end for;

end Ex3_5;
//=================
