//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-4: Fluid Kinematics   
//Example 4.2  Page 142
//Title: Acceleration of a Fluid Particle through a Nozzle

model Ex4_2
extends Modelica.Constants;

//=================
//Parameter Section
parameter Real v(unit = "ft3/s") = 0.00187  "Volume flow rate";
parameter Real D_in(unit = "ft") = 0.0350 "Inlet diameter of nozzle";
parameter Real D_out(unit = "ft") = 0.01516 "Outlet diameter of nozzle";
parameter Real del_x(unit = "ft") = 0.325 "Length of nozzle";

//=================
//Variable Section 
Real u_inlet(unit = "ft/s") "Inlet speed";
Real u_outlet(unit = "ft/s") "Outlet speed";
Real a_x(unit = "ft/s2") "Magnitude of acceleration";

//=================
//Equation Section
equation 
u_inlet = (4*v)/(pi*D_in^2);
u_outlet = (4*v)/(pi*D_out^2);
a_x = ((u_outlet^2)-(u_inlet^2))/(2*del_x);

end Ex4_2;
//=================
