//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-5: Bernoulli and Energy Equations   
//Example 5.1  Page 196
//Title:  Water Flow through a Garden Hose Nozzle

package Ex5_1
model Ex5_1_a
extends Modelica.Constants;

//=================
//Parameter Section
parameter Real del_V(unit = "gal") = 10 "Volume of bucket";
parameter Real del_T(unit = "s") = 50 "Time period to fill the bucket";
parameter Real Rho(unit = "kg/L") = 1 "Density of water";

//=================
//Variable Section 
Real v(unit = "L/s") "Volumetric flow rate";
Real m(unit = "kg/s") "Mass flow rate";

//=================
//Equation Section 
equation 
v = (del_V/del_T)*(3.7854/1); 
//v multiplied by 3.7854 to convert gal/s to L/gal;
m = Rho*v;

end Ex5_1_a;
//==================

model Ex5_1_b
extends Ex5_1_a;

//=================
//Parameter Section
parameter Real De(unit = "cm") = 0.8 "Diameter of the hose at the nozzle exit";

//=================
//Variable Section 
Real re(unit = "m") "Radius of the hose at the nozzle exit";
Real Ae(unit = "m2") "Cross-sectional area of the nozzle exit";
Real Ve(unit = "m/s") "Average velocity of water at the nozzle exit";

//=================
//Equation Section 
equation 
re = (De/2)*0.01;
Ae = pi*(re^2);
Ve = (v/Ae)*(1/1000); 
//Ve divided by 1000 and multiplied by 1 to convert it to m3/s

end Ex5_1_b;
//==================

end Ex5_1;

//==================



