//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-5: Bernoulli and Energy Equations   
//Example 5.3  Page 201
//Title:  Pumping Water from a Lake to a Storage Tank

package Ex5_3
model Ex5_3_a

//=================
//Parameter Section
parameter Real Rho_w(unit = "kg/m3") = 1000 "Density of water";
parameter Real v(unit = "L/s") = 70 "Volumetric flow rate of water";
parameter Real z1(unit = "m") = 0 "Reference level at the surface of lake";
parameter Real z2(unit = "m") = 18 "Level of water pumped from a lake to a storage tank";
parameter Real W_elec(unit = "kW") = 20.4 "Electric power consumed";
parameter Real g(unit = "m/s2") = 9.81 "Gravitational constant";

//=================
//Variable Section 
Real m(unit = "kg/s") "Mass flow rate of water";
Real pe_2(unit = "kJ/kg") "Potential energy at point 2";
Real del_E_mech(unit = "kW") "Rate of increase of the mechanical energy of water";
Real Ef(unit = "%") "Overall efficiency of the combined pump–motor unit" ;

//=================
//Equation Section 
equation 
m = Rho_w*v*0.001;
//Multiplying v by 0.001 to convert L/s to m3/s

pe_2 = g*z2*1/1000; 
//Multiplying pe_2 by 1 and dividing by 1000 to convert it ito kJ/kg

del_E_mech = pe_2*m;
Ef = (del_E_mech/W_elec)*100;

end Ex5_3_a;
//==================

model Ex5_3_b
extends Ex5_3_a;

//=================
//Variable Section 
Real del_P(unit = "kPa") "Pressure difference between the inlet and the exit of the pump";

//=================
//Equation Section 
equation 
del_P = del_E_mech/(v*0.001); 
//Multiplying v by 0.001 to convert L/s to m3/s

end Ex5_3_b;

//==================

end Ex5_3;

//==================
