//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-5: Bernoulli and Energy Equations   
//Example 5.5  Page 212
//Title:  Spraying Water into the Air

model Ex5_5

//=================
//Parameter Section
parameter Real Pgage(unit = "kPa") = 400 "Pressure in the hose";
parameter Real Rho(unit = "kg/m3") = 1000 "Density of water";
parameter Real g(unit = "m/s2") = 9.81 "Gravitational constant";
parameter Real z1(unit = "m") = 0 "Elevation just below the hose outlet as the reference level";

//=================
//Variable Section 
Real z2(unit = "m") "the maximum height that the jet could achieve";

//=================
//Equation Section 
equation 
z2 = Pgage/(Rho*g)*(1000/1); //Reduced form of bernoulli equation

end Ex5_5;
//==================
