//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-5: Bernoulli and Energy Equations   
//Example 5.6  Page 213
//Title:  Water Discharge from a Large Tank

model Ex5_6

//=================
//Parameter Section
parameter Real z1(unit = "m") = 5 "Water level in the tank";
parameter Real z2(unit = "m") = 0 "Reference level at the center of the outlet";
parameter Real g(unit = "m/s2") = 9.81 "Gravitational constant";

//=================
//Variable Section 
Real V2(unit = "m/s") "Maximum water velocity at the outlet";

//=================
//Equation Section 
equation 
//Torricelli equation
V2 = sqrt(2*z1*g); //Reduced form of bernoulli equation

end Ex5_6;
//==================
