//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-6: Momentum Analysis of flow systems 
//Example 6.7 Page 268 
//Title: Net Force on a Flange

model Ex6_7
extends Modelica.Constants;

//=================
//Parameter Section
parameter Real v(unit = "gal/min") = 18.5 "Volumetric flow rate of water";
parameter Real D(unit = "ft") =  0.0650 "Inner diameter of the pipe at the location of the flange";
parameter Real D_c(unit = "in") = 0.78 "Convered Inner diameter in inch";
parameter Real P1(unit = "psig") = 13 "Pressure at the location of the flange";
parameter Real Rho(unit = "lbm/ft3") = 62.3 "Density of water at the room temperature";
parameter Real W(unit = "lbf") = 12.8 "Total weight of the faucet assembly plus the water";

//=================
//Variable Section 
Real A(unit = "ft2") "Area of the pipe";
Real V(unit = "ft/s") "Velocity of the water"; //V=V1=V2 , Since inner diameter is constant
Real m(unit = "lbm/s") "Mass flow rate of water"; 
Real FR_x(unit = "lbf") "x component of the force acting on the flange";
Real FR_z(unit = "lbf") "z component of the force acting on the flange";

//=================
//Equation Section
equation 
A = ((pi/4)*D^2);
V = (v/A)*(0.1337/60);
m = (Rho*v)*(0.1337/60);
//Multipyling by 0.1337 convert gal/min to ft3/min
//Diving by 60 to convert /min to /s

//From momentum equation for steady flow
FR_x = (-m*(V/32.2))-(P1*((pi/4)*(D_c^2)));
FR_z = (-m*(V/32.2))+W;
//Converting FR from lbm to lbf

//Net force of the flange on the control volume is expressed in vector form
//F_flange = (FR_x)i+(FR_z)j;
//F_faucet on flange = -F_flange

end Ex6_7;
//=================
