//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-7: Dimensional Analysis and Modeling 
//Example 7.10 Page 327 
//Title: Model Truck Wind Tunnel Measurements

model Ex7_10

//=================
//Parameter Section
parameter Real W_m(unit = "m") = 0.159 "Width of the model truck";
parameter Real h_m(unit = "m") = 0.257 "Height of model truck";

//From Table 7-7, Page no.328
parameter Real [11] V_m(each unit = "m/s") = {20,25,30,35,40,45,50,55,60,65,70}"Wind tunnel speed for the model truck";
parameter Real [11] FD_m(each unit = "N") = {12.4,19,22.1,29,34.3,39.9,47.2,55.5,66.0,77.6,89.9}"Aerodynamic drag
force on a model truck";

parameter Real V_p(unit = "m/s") = 26.8 "Speed of the prototype truck";

//Properties of air calculated at 25 C and aatmospheric pressure for both the model and prototype
parameter Real Rho(unit = "kg/m3") = 1.184 "Density of air at atmospheric pressure"; 
parameter Real mu(unit = "kg/m.s") = 1.849*0.00001 "Viscosity of air at atmospheric pressure";

//=================
//Variable Section 
Real W_p(unit = "m") "Width of the protype truck";
Real Re_p(unit = "-") "Reynolds number for the prototype";
Real FD_p(unit = "-") "Predicted aerodynamic drag on the prototype";
Real A_m(unit = "m2") "Area of the model truck";
Real Cd_p(unit = "-") "Drag coefficient for prototype truck";
Real [11] Cd_m(each unit = "-") "Drag coefficient for model truck";
Real [11] Re_m(each unit = "-") "Reynolds number for model truck";
String Analysis;

//=================
//Equation Section
equation 
A_m = W_m*h_m;
for i in 1:11 loop
Cd_m[i] = FD_m[i]/((1/2)*Rho*A_m*(V_m[i]^2));
Re_m[i] = (Rho*V_m[i]*W_m)/mu;
end for;

W_p = 16*W_m; 
//Prototype is specified as 16 times that of the model

Re_p = (Rho*V_p*W_p)/(mu);

//From the Plot or Loop -  CD remains constant as Re is increased to that of the full-scale prototype
Cd_p = 0.76; 
FD_p = (1/2)*Rho*(V_p)^2*(16^2*A_m)*Cd_p;


//Analysis
if Re_m[11]>Re_p then
Analysis = "Dynamic similarity has been achieved";
else
Analysis = "Dynamic similarity has not been achieved";
end if;

Modelica.Utilities.Streams.print(Analysis); 

/*Since CD remains constant as Re is increased, 
Reynolds number independence has been achieved*/

//The answer may slightly vary due to rounding off values

//=================
 
end Ex7_10;

//=================
