//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-7: Dimensional Analysis and Modeling 
//Example 7.11 Page 330 
//Title: Model Lock and River

model Ex7_11

//=================
//Parameter Section

parameter Real L_ratio(unit = "-") = 1/100 "Ratio of scaling"; //L_m/L_p

//Properties of water determined at the temperature - 20 C and atm.pr for the prototype
parameter Real v_p(unit = "m2/s") = 1.002*0.000001 "Kinematic viscosity of the prototype";

//=================
//Variable Section 
Real v_m(unit = "m2/s") "Required kinematic viscosity of model liquid";

//=================
//Equation Section
equation 
v_m = v_p*(L_ratio)^(3/2);

//Water is typically used in such tests for convenience

end Ex7_11;
//=================
