//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-7: Dimensional Analysis and Modeling 
//Example 7.6 Page 308 
//Title: Prediction of Aerodynamic Drag Force on a Prototype Car

model Ex7_6

//=================
//Parameter Section
//Prototype - The aerodynamic drag of a new sports car is predicted at an air temperature
//Model -  One-fifth scale model of the car to test in a wind tunnel temperature

parameter Real L_ratio(unit = "-") = 5 "Ratio of scaling"; //L_p/L_m

//Properties of air determined at the prototype temperature
parameter Real Rho_p(unit = "kg/m3") = 1.184 "Density of prototype";
parameter Real V_p(unit = "mi/h") = 50 "Speed of the car prototype";

//Properties of air determined at the model temperature
parameter Real Rho_m(unit = "kg/m3") = 1.269 "Density of model";

//From solution Ex7_5
parameter Real V_m(unit = "mi/h") = 221 "Wind tunnel speed for the model tests"; 
parameter Real F_Dm(unit = "lbf") = 21.2 "Aerodynamic drag force on the model car";

//=================
//Variable Section 
Real F_Dp(unit = "lbf") "Unknown aerodynamic drag force on the prototype car";

//=================
//Equation Section
equation 
F_Dp = F_Dm*(Rho_p/Rho_m)*(V_p/V_m)^2*(L_ratio)^2;

end Ex7_6;
//=================
