//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-9: Differential Analysis of Fluid Flow
//Example 9.11 Page 461
//Title: Volume Flow Rate Deduced from Streamlines

model Ex9_11

//=================
//Parameter Section
parameter Real V(unit = "m/s") = 1 "Uniform velocity";
parameter Real w(unit = "m") = 2 "Width of channel";

//From Figure 9-26, Page No.462
parameter Real S_wall(unit = "m2/s") = 0 "Volume flow rate per unit width between the bottom wall";
parameter Real S_dividing(unit = "m2/s") = 1 "Volume flow rate per unit width between dividing streamline";
parameter Real del(unit = "m") = 0.21 "Streamline location";
parameter Real S_1(unit = "m2/s") = 1.8 "Stream line from Figure";
parameter Real S_2(unit = "m2/s") = 1.6 "Stream line from Figure";

//=================
//Variable Section 
Real Ratio_1(unit = "m2/s") "Ratio of v/w";
Real v(unit = "m3/s") "Volumetric flow rate";
Real V_A(unit = "m/s") "Speed at point A";

//=================
//Equation Section
equation 
Ratio_1 = S_dividing - S_wall; // Ratio_1 = v/w
v = Ratio_1*w;
V_A = (1/del)*(S_1-S_2);

end Ex9_11;

//==================
