//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-10: Approximate Solutions of the Navier-Stokes Equation
//Example 10.9 Page 563
//Title: Laminar or Turbulent Boundary Layer?

model Ex10_9

//=================
//Parameter Section
parameter Real V(unit = "mi/h") = 3.5 "Speed of water under the canoe";
parameter Real x(unit = "ft") = 20 "Length of canoe";
parameter Real KV(unit = "ft2/s") = 1.407*0.00001 "Kinematic viscosity of water at 50 F";

//=================
//Variable Section 
Real Re(unit = "-") "Reynolds number";
String Flow;

//=================
//Equation Section
equation 
Re = ((V*x)/(KV))*(5280/3600); 
//Multiplying V by 5280 to convert mi/h to ft/h
//Dividing V by 3600 to convert ft/h to ft/s

if Re>(5*10^5)
then
Flow = "Turbulent";
else 
Flow = "Laminar";
end if;

Modelica.Utilities.Streams.print(Flow);

end Ex10_9;
//=================
