//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-11: External Flow: Drag and Lift    
//Example 11.6  Page 646
//Title:  Effect of Spin on a Tennis Ball

model Ex11_6
extends Modelica.Constants;

//=================
//Parameter Section
parameter Real V(unit = "mi/h") = 45 "Translational velocity of the ball";
parameter Real omega(unit = "rpm") = 4800 "Angular velocity of the ball";
parameter Real D(unit = "in") = 2.52 "Diameter of the tennis ball";
parameter Real m(unit = "lbm") = 0.125 "Mass of tennis ball";
parameter Real g(unit = "ft/s2") = 32.2 "Gravitational constant";
parameter Real Rho_a(unit = "lbm/ft3") = 0.07350 "Density of air at 1 atm and 80 F";

//=================
//Variable Section 
Real A(unit = "ft2") "Frontal area of the ball";
Real V_c(unit = "ft/s") "Converted translational velocity from mi/h to ft/s";
Real omega_c(unit = "rad/s") "Converted angular velocity from rpm to rad/s";
Real RR(unit = "rad") "Nondimensional rate of rotation";
Real F_L(unit = "lbf") "Lift force acting on the ball";
Real W(unit = "lbf") "Weight of the ball";
Real C_L(unit = "-") "Lift coefficient";
String Analysis;

//=================
//Equation Section 
equation 
A = (pi/4)*(D/12)^2; 
//Dividing D by 12 to convert in to ft;

V_c = V*(5280/3600); 
//Multiplying V by 5280 and dividing by 3600 to convert mi/h to ft/s

omega_c = omega*2*pi/60; 
//Multiplying omega by 2*pi and dividing by 60 to convert rpm to rad/s

RR = (omega_c*(D/12))/(2*V_c); 
//Dividing D by 12 to convert in to ft;

//From Figure 11-53, Page no.646
C_L = 0.21; 
//Lift coefficient corresponding to rate of rotation value

F_L = C_L*A*Rho_a*(V_c^2)/(2*32.2); 
W = (m*g)/32.2; 
//Dividing by 32.2 to convert lbm to lbf

//Analysis
if W>F_L then 
Analysis = "the ball will drop under the combined effect of gravity and lift due to spinning with a net force";
else 
Analysis = "the ball will not drop under the combined effect of gravity and lift due to spinning with a net force";
end if; 

Modelica.Utilities.Streams.print(Analysis);

end Ex11_6;
//==================
