//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-12: Compressible Flow  
//Example 12.14  Page 717
//Title: Choked Fanno Flow in a Duct

model Ex12_15
extends Modelica.Constants;

//=================
//Parameter Section
parameter Real Cp(unit = "kJ/kg K") = 1.005 "Specific heat capacity";
parameter Real R(unit = "kJ/kg K") = 0.287 "Gas constant";
parameter Real k(unit = "-") = 1.4 "Specific heat ratio";
parameter Real kv(unit = "m2/s") = 1.58*0.00001 "KInematic viscosity";
parameter Real Ma1(unit = "-") = 0.4 "Mach number at the inlet";
parameter Real Ma2(unit = "-") = 1 "Mach number at the duct exit";
parameter Real D(unit = "cm") = 3 "Diameter of smooth adiabatic duct ";
parameter Real T1(unit = "K") = 300 "Inlet temperature of the air";
parameter Real P1(unit = "kPa") = 150 "Inlet pressure of the air";

//Fanno flow functions corresponding to the inlet Mach number of 0.4 
//From Table A-16, Page No.964
parameter Real PR0(unit = "-") = 1.5901 "Ratio of pressure in sonic condition" ;//PR0 = P01/P0*
parameter Real TR(unit = "-") = 1.1628 "Ratio of temperature in sonic condition" ;//TR = T1/T*
parameter Real PR1(unit = "-") = 2.6958 "Ratio of pressure in sonic condition"; //PR1 = P1/P*
parameter Real VR(unit = "-") = 0.4313 "Ratio of velocity in sonic condition" ;//VR = V1/V*
parameter Real FR(unit = "-") = 2.3085 "Ratio of friction factor to diameter"; //FR= f*L/D
                 
//=================
//Variable Section 
Real c1(unit = "m/s") "Speed of sound at inlet";
Real V1(unit = "m/s") "Velocity of air";
Real Re1(unit = "-") "Reynolds number at the inlet";
Real f(unit = "-") "Friction factor";
Real Ls(unit = "m") "Duct length at the exit";
Real Ts(unit = "K") "Exit temperature";
Real Ps(unit = "kPa") "Exit pressure";
Real Vs(unit = "m/s") "Exit velocity";
Real PF(unit = "%") "Fraction of inlet stagnation pressure P01 lost in the duct due to friction";

//=================
//Equation Section 
equation 
c1 = sqrt(k*R*T1*1000);
V1 = Ma1*c1;

Re1 = (V1*D*0.01)/kv;
//Multiplying D by 0.01 to convert cm to m

//Colebrook equation
(1/sqrt(f)) = (-2)*log10(2.51/(Re1*sqrt(f)));

Ls = (FR*D*0.01)/f;
Ts = T1/TR;
Ps = P1/PR1;
Vs = V1/VR;
PF = (1-(1/PR0))*100;


end Ex12_15;

//==================
