//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-12: Compressible Flow  
//Example 12.5  Page 681
//Title: Air Loss from a Flat Tire

model Ex12_5
extends Modelica.Constants;

//=================
//Parameter Section
parameter Real R(unit = "kPa⋅m3/kg⋅K") = 0.287 "Specific gas constant of air ";
parameter Real k(unit = "-") = 1.4 "Specific heat ratio of air at room temperature";
parameter Real T0(unit = "C") = 25 "Ambient temperature of air in the tire";
parameter Real Pgage(unit = "kPa") = 220 "Gage pressure maintained in the tire";
parameter Real D(unit = "mm") = 4 "Diameter leak developed in the tire due to accident";
parameter Real Patm(unit = "kPa") = 94 "Atmospheric pressure";
parameter Real PR(unit = "-") = 0.5283 "Pressure ratio";
              //P_R = P*/P0, From Table 12-2, Page no-677


//=================
//Variable Section 
Real P0(unit = "kPa") "Absolute pressure in the tire";
Real P_c(unit = "kPa") "Critical pressure in the  tire";
Real Rho_o(unit = "kg/m3") "Density of air at the exit";
Real Rho_c(unit = "kg/m3") "Critical density";
Real T_c(unit = "K") "Critical temperature in the tire";
Real V(unit = "m/s") "Velocity at the exit of the hole";
Real m(unit = "kg/min") "Initial mass flow rate through the hole";
Real A(unit = "m2") "Area of the hole";

//=================
//Equation Section 
equation 
P0 = Pgage + Patm;
P_c = PR*P0; 
Rho_o = P0/(R*(T0+273)); 
//Adding 273 to T to convert C to K

Rho_c = Rho_o*(((2)/(k+1))^(1/(k-1)));
T_c = ((2)/(k+1))*(T0+273);
V = sqrt(k*R*1000*T_c);

A = (pi/4)*(D*0.001)^2; 
//Multiplying D by 0.001 to convert mm to m;

m = (Rho_c*A*V)*60; 
//Multiplying m by 60 to convert kg/s to kg/min

end Ex12_5;
//==================
