//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-13: Open-Channel Flow
//Example 13.11 Page 778
//Title: Measuring Flow Rate by a Weir

model Ex13_11

//=================
//Parameter Section
parameter Real y_1(unit = "m") = 1.5 "Water depth upstream";
parameter Real g(unit = "m/s2") = 9.81 "Gravitational constant";
parameter Real Pw(unit = "m") = 0.6 "Height of sharp-crested rectangular weir";
parameter Real b(unit = "m") = 5 "Width of open channel";

//=================
//Variable Section 
Real H(unit = "m") "Weir head";
Real Cd_weir(unit = "-") "Discharge coefficient of the weir";
Real v(unit = "m3/s") "Water flow rate through the channel";
String Condition;
Real V1(unit = "m/s") "Upstream velocity";
Real VH(unit = "m") "Upstream velocity head";

//=================
//Equation Section 
equation 
H = y_1-Pw;

//Checking condition satisfaction
if (H/Pw)<2 then
Condition = "Satisfied";
else
Condition = "Not Satisfied";
end if;

Modelica.Utilities.Streams.print(Condition);                      

Cd_weir = 0.598 + (0.0897*(H/Pw));
v = Cd_weir*(2/3)*b*(sqrt(2*g*((H)^(3/2))));

V1 = v/(b*y_1);
VH = V1^2/(2*g);

//The answer may slightly vary due to rounding off values"

end Ex13_11;
//==================
