//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-13: Open-Channel Flow
//Example 13.3 Page 749
//Title: The Height of a Rectangular Channel

model Ex13_3
extends Modelica.Constants;

//=================
//Parameter Section
parameter Real b(unit = "ft") = 4 "Width of unfinished-concrete rectangular channel";
parameter Real v1(unit = "ft3/s") = 51 "Flow rate of water";
parameter Real v2(unit = "ft3/s") = 51 "Flow rate of water";
parameter Real h1(unit = "ft") = 2 "Elevation of bottom drop"; //Case-1
parameter Real h2(unit = "ft") = 1 "Elevation of bottom drop"; //Case-2
parameter Real a(unit = "ft^(1/3)/s") = 1.486 "Dimensional constant";

//From Table 13-1, Page No.747
parameter Real n(unit = "-") = 0.014 "Manning coefficient for an open channel of unfinished concrete";

//=================
//Variable Section 
Real A_c_1(unit = "ft2") "Cross sectional area in case-1";
Real p_1(unit = "ft") "Perimeter case-1";
Real R_h_1(unit = "ft") "Hydraulic radius case-1";
Real A_c_2(unit = "ft2") "Cross sectional area case-2";
Real p_2(unit = "ft") "Perimeter case-2";
Real R_h_2(unit = "ft") "Hydraulic radius case-2";
Real S0_1(unit = "-") "Bottom slope of the channel case-1"; 
Real S0_2(unit = "-") "Bottom slope of the channel case-2"; 
Real y_1(unit = "ft") "Minimum height of the channel under uniform-flow conditions case-1";
Real y_2(unit = "ft") "Minimum height of the channel under uniform-flow conditions case-2";

//=================
//Equation Section 
equation 
/*Case-1 -  Channel bottom drops 2 ft per 1000 ft length*/
A_c_1 = b*y_1;
p_1 = b + (2*y_1);
R_h_1 = (b*y_1)/(b+(2*y_1));

S0_1 = h1/1000; 
//Dividing by per feet length

v1 = (a/n)*b*y_1*(R_h_1^(2/3))*(S0_1^(1/2));

/*Case-2 - Bottom drop is just 1 ft per 1000 ft length*/
A_c_2 = b*y_2;
p_2 = b + (2*y_2);
R_h_2 = (b*y_2)/(b+(2*y_2));

S0_2 = h2/1000; 
//Dividing by per feet length

v2 = (a/n)*b*y_2*(R_h_2^(2/3))*(S0_2^(1/2));

end Ex13_3;
//==================
