//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-13: Open-Channel Flow
//Example 13.8 Page 767
//Title: Hydraulic Jump

package Ex13_8
model Ex13_8_a

//=================
//Parameter Section
parameter Real y_1(unit = "m") = 0.8 "Flow depth before jump";
parameter Real g(unit = "m/s2") = 9.81 "Gravitational constant";
parameter Real V_1(unit = "m/s") = 7 "Velocity before jump";
parameter Real b(unit = "m") = 10 "Width of rectangular horizontal channel";
parameter Real Rho_w(unit = "kg/m3") = 1000 "Density of water";

//=================
//Variable Section
Real Fr_1(unit = "-") "Froude number before the hydraulic jump";
Real Fr_2(unit = "-") "Froude number after the hydraulic jump";
Real V_2(unit = "m/s") "Velocity after jump";
Real y_2(unit = "m") "Flow depth after jump";

//=================
//Equation Section 
equation 
Fr_1 = V_1/sqrt(g*y_1);
y_2 = 0.5*y_1*(-1+(sqrt(1+(8*Fr_1^2))));
V_2 = (y_1/y_2)*V_1;
Fr_2 = V_2/sqrt(g*y_2);

end Ex13_8_a;

//==================

model Ex13_8_b
extends Ex13_8_a;

//=================
//Variable Section
Real h_L(unit = "m") "Head loss";
Real E_s1(unit = "m") "Specific energy of water before the jump";
Real DR(unit = "-") "Dissipation ratio";

//=================
//Equation Section 
equation 
h_L = y_1-y_2+(((V_1^2)-(V_2^2))/(2*g));
E_s1 = y_1 + ((V_1^2)/(2*g));
DR = h_L/E_s1;

end Ex13_8_b;
//=================

model Ex13_8_c
extends Ex13_8_a;
extends Ex13_8_b;

//=================
//Variable Section
Real m(unit = "kg/s") "Mass flow rate of water";
Real E_dissipated(unit = "kW") "Power dissipation corresponding to a head loss";

//=================
//Equation Section 
equation 
m = Rho_w*b*y_1*V_1;
E_dissipated = (m*g*h_L)/1000; 
//Dividing by 1000 to convert W to kW

end Ex13_8_c;


//=================

end Ex13_8;

//=================
