//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-13: Open-Channel Flow
//Example 13.9 Page 771
//Title: Sluice Gate with Drowned Outflow

model Ex13_9

//=================
//Parameter Section
parameter Real y_1(unit = "m") = 3 "Depth of flow before turbulence subsides";
parameter Real y_2(unit = "m") = 1.5 "Depth of flow after turbulence subsides";
parameter Real a(unit = "m") = 0.25 "Height of opening at the channel bottom";
parameter Real g(unit = "m/s2") = 9.81 "Gravitational constant";
parameter Real b(unit = "m") = 6 "Width of the channel";

//From Figure 13-46, Page No.771
parameter Real Cd(unit = "-") = 0.47 "Discharge coefficient";

//=================
//Variable Section 
Real DR(unit = "-") "Depth ratio";
Real CC(unit = "-") "Contraction coefficient";
Real v(unit = "m3/s") "Discharge rate of water";

//=================
//Equation Section 
equation 
DR = y_1/a;
CC = y_2/a;
v = Cd*b*a*(sqrt(2*g*y_1));

end Ex13_9;
//==================
