//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-14: Turbomachinery
//Example 14.11 Page 837
//Title: Design of a New Geometrically Similar Pump

package Ex14_11
model Ex14_11_a

//=================
//Parameter Section

//Pump-A uses water  
parameter Real D_A(unit = "cm") = 6 "Diameter of the impeller";
parameter Real omega_A(unit = "rad/s") = 180.6 "Speed of impeller";
parameter Real Rho_w(unit = "kg/m3") = 998 "Density of water";
parameter Real g(unit = "m/s2") = 9.81 "Gravitational constant";

//From Table 14-2, Page no.837
parameter Real [7] v_A(each unit = "cm3/s") = {100,200,300,400,500,600,700}"Volume flow rate of water";
parameter Real [7] H_A(each unit = "cm") = {180,185,175,170,150,95,54} "Net head of the water";
parameter Real [7] Eff_A(each unit = "%") = {32,54,70,79,81,66,38} "Efficiency of the pump";

//=================
//Variable Section 
Real [7] bhp_A(each unit = "W") "Brake horse power for Pump-A";
Real [7] C_Q(each unit = "-") "Capacity coefficient for Pump-A";
Real [7] C_H(each unit = "-") "Head coefficient for Pump-A";
Real [7] C_p(each unit = "-") "Power coefficient for Pump-A";

//=================
//Equation Section 
equation
for i in 1:7 loop
bhp_A[i] = (Rho_w*g*v_A[i]*(0.01^3)*H_A[i]*0.01)/(Eff_A[i]/100);
C_Q[i] = v_A[i]/(omega_A*(D_A)^3);
C_H[i] = (g*H_A[i]*0.01)/(omega_A^2*(D_A*0.01)^2);
C_p[i] = bhp_A[i]/(Rho_w*omega_A^3*(D_A*0.01)^5);
end for;

end Ex14_11_a;

//==================

model Ex14_11_b
extends Ex14_11_a;

//=================
//Parameter Section

//Pump-B uses Liquid refrigirent R-134a 
parameter Real H_B(unit = "cm") = 450 "Net head of water at pump B";
parameter Real Rho_r(unit = "kg/m3") = 1226 "Density of refrigirent";
parameter Real v_B(unit = "cm3/s") = 2400 "Flowrate in Pump-B";

//From Solution-Plot of Ex14_11_a, Obtaining the points at BEP
parameter Real C_Qs(unit = "-") = 0.0112 "Capacity coefficient for Pump-B";
parameter Real C_Hs(unit = "-") = 0.133 "Head coefficient for Pump-B";
parameter Real C_ps(unit = "-") = 0.00184 "Power coefficient for Pump-B";
parameter Real Eff_B(unit = "-") = 0.812 "Efficiency of Pump-B";

//=================
//Variable Section 
Real D_B(unit = "m") "Diameter of pump B";
Real bhp_B(unit = "W") "Brake horse power for Pump-B";
Real omega_B(unit = "rad/s") "Rotational speed for Pump-B";

//=================
//Equation Section 
equation
D_B = (((v_B*0.01^3)^2*(C_Hs))/(C_Qs^2*g*H_B*0.01))^(1/4);
//Multiplying H_B by 0.01 to convert cm to m

omega_B = ((v_B*0.01^3))/(C_Qs*D_B^3);
//Multiplying v_B by 0.01^3 to convert cm3/s to m3/s

bhp_B = C_ps*Rho_r*(omega_B^3)*(D_B^5);

end Ex14_11_b;

//==================

end Ex14_11;

//==================
