//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-14: Turbomachinery
//Example 14.12 Page 850
//Title: Effect of Component Efficiencies on Plant Efficiency

model Ex14_12

//=================
//Parameter Section
parameter Real n_T(unit = "-") = 12 "Number of identical parallel turbines";
parameter Real H_gross(unit = "ft") = 1065 "Gross head from the reservoir to the tailrace";
parameter Real v(unit "gal/min") = 203000 "Flowrate of water through each turbine";
parameter Real Eff_t(unit = "%") = 95.2 "Efficiency of each turbine";
parameter Real Eff_g(unit = "%") = 94.5 "Efficiency of the generator";
parameter Real Eff_o(unit = "%") = 3.5 "Efficiency of other";
parameter Real g(unit = "ft/s2") = 32.2 "Gravitational constant";
parameter Real Rho(unit = "lbm/ft3") = 62.3 "Density of water at 70 F";

//=================
//Variable Section 
Real W_ideal(unit = "MW") "Ideal power produced by one hydroturbine";
Real W_electrical(unit = "MW") "Actual electrical power output of each turbine";
Real W_total_electrical(unit = "MW") "Total electrical power output of all turbines";

//=================
//Equation Section 
equation
W_ideal = (Rho*g*v*H_gross)*((0.1337*1.356)/(32.2*60*10^6));
//Dividing W-ideal by 10^6 to convert W to MW

W_electrical = W_ideal*(Eff_t/100)*(Eff_g/100)*(1-(Eff_o/100));
W_total_electrical = W_electrical*n_T;

end Ex14_12;
//==================
