//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-14: Turbomachinery
//Example 14.2 Page 802
//Title: Selection of Pump Impeller Size

model Ex14_2

//=================
//Parameter Section
parameter Real Rho_w(unit = "lbm/ft3") = 62.3 "Density of water at 70 F";
parameter Real g(unit = "lbm.ft/s2") = 32.2 "Gravitational constant";
parameter Real v(unit = "gal/min") = 370 "Flow rate of water";

//Option-1 - 8.25 inch impeller
//Option-2 - 12.75 inch impeller
parameter Real H_1(unit = "ft") = 24 "Required net head for impeller option-1";
parameter Real Eff_1(unit = "%") = 70 "Efficiency of this pump for impeller option-1";

//using the operating point of that pump
parameter Real H_2(unit = "ft") = 72 "Required net head for impeller option-2";
parameter Real Eff_2(unit = "%") = 76.5 "Efficiency of this pump for impeller option-2";

String Best_impeller;

//=================
//Variable Section 
Real bhp_1(unit = "hp") "Required bhp for the 8.25-in impeller option";
Real bhp_2(unit = "hp") "Required bhp for the 12.75-in impeller option";

//=================
//Equation Section 
equation 
bhp_1 = (Rho_w*g*v*H_1*0.1337*100)/(32.2*60*550*Eff_1);
bhp_2 = (Rho_w*g*v*H_2*0.1337*100)/(32.2*60*550*Eff_2);
//Conversion of unit to hp
//Dividing by 60 to convert min to s


//Comparison of Impeller    
if bhp_1<bhp_2 then
Best_impeller = "Option-1 Impeller is the best choice";
else
Best_impeller = "Option-2 Impeller is the best choice";
end if;

Modelica.Utilities.Streams.print(Best_impeller);
end Ex14_2;
//==================
