//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-14: Turbomachinery
//Example 14.3 Page 804
//Title: Maximum Flow Rate to Avoid Pump Cavitation

model Ex14_3
extends Modelica.Constants;

//=================
//Parameter Section
parameter Real K_L1(unit = "-") = 0.5 "Minor loss coefficient at sharp-edged inlet";
parameter Real K_L2(unit = "-") = 0.3 "Minor loss coefficient at flanged smooth 90° regular elbow";
parameter Real n_E(unit = "-") = 3 "Number of flanged smooth 90° regular elbow";
parameter Real K_L3(unit = "-") = 6 "Minor loss coefficient for a fully open flanged globe valve";
parameter Real ID(unit = "in") = 4 "Inner diameter of pipe";
parameter Real RF(unit = "-") = 0.005 "Roughness factor";
parameter Real g(unit = "m/s2") = 9.81 "Gravitational constant";
parameter Real del_Z(unit = "m") = 1.219 "Height";
parameter Real L(unit = "ft") = 10.5 "Length of piping system from pump to reserviour";

//Properties of water estimated at 25 C
parameter Real Rho_w(unit = "kg/m3") = 997 "Density of water";
parameter Real mu(unit = "kg/m.s") = 8.91*0.0001 "Viscosity of water";
parameter Real Pv(unit = "kPa") = 3.169 "Vapour pressure";
parameter Real Patm(unit = "kPa") = 101.3 "Standard atmospheric pressure";

//Assumption -  The flow at the pump inlet is turbulent and fully developed
parameter Real alpha(unit = "-") = 1.05 "Kinetic factor";

//Volume flow rate values in the form of array 
parameter Real [5] v(each unit = "gpm") = {300,400,500,600,700}"Volume flow rate";

//=================
//Variable Section 
Real KL_sum(unit = "-") "Sum of loss coefficient";
Real [5] V(each unit = "m/s") "Average speed of water through the pipe";
Real [5] NPSH(each unit = "m") "Available net positive suction head";
Real [5] NPSH_C(each unit = "ft") "Converted Available net positive suction head";
Real [5] Re(each unit = "-") "Reynolds number";
Real [5] f(each unit = "-") "Friction factor";

//=================
//Equation Section 
equation 
KL_sum = K_L1 + (n_E*K_L2) + K_L3;

for i in 1:5 loop
V[i] = ((4*(v[i]/15850.32))/(pi*ID^2))*(1/0.0254)^2;
//Dividing V by 15850.32 to convert gpm to m3/s

Re[i] = (Rho_w*V[i]*(ID/39.37))/mu;
//Dividing ID by 39.37 to convert inch to m

//Colbroke Equation
1/sqrt(f[i])=-2*log10((RF/3.7)+(2.51/(Re[i]*sqrt(f[i]))));

NPSH[i] = (((Patm*1000)-(Pv*1000))/(g*Rho_w))+del_Z-(((f[i]*(L/(ID/12)))+KL_sum-(alpha-1))*((V[i]^2)/(2*g)));
//Multiplying P by 1000 to convert kPa to Pa

NPSH_C[i] = NPSH[i]*3.281;
//Multiplying NPSH by 3.281 to convert m to ft
end for;

//From the plot, Cavitation occurs at flow rates above 600 gpm 

end Ex14_3;
//==================
