//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-14: Turbomachinery
//Example 14.5 Page 816
//Title: Idealized Blower Performance

model Ex14_5
extends Modelica.Constants;

//=================
//Parameter Section
parameter Real v(unit = "m3/s") = 0.13 "Flow rate of air";
parameter Real r_1(unit = "cm") = 4 "Inlet radius";
parameter Real r_2(unit = "cm") = 8 "Outlet radius";
parameter Real b_1(unit = "cm") = 5.2 "Inlet blade width";
parameter Real b_2(unit = "cm") = 2.3 "Outlet blade width";
parameter Real alpha_1(unit = "degree") = 0 "Angle made when air enters the impeller normal to the blade";
parameter Real alpha_2(unit = "degree") = 40 "Angle made when air exits the impeller from normal";
parameter Real omega(unit = "rad/s") = 183.3 "Angular speed";
parameter Real Rho_air(unit = "kg/m3") = 1.2 "Density of air";
parameter Real Rho_water(unit = "kg/m3") = 998 "Density of water";
parameter Real g(unit = "m/s2") = 9.81 "Gravitational constant";

//=================
//Variable Section 
Real V1_n(unit = "m/s") "Normal velocity component at the inlet";
Real V1_t(unit = "m/s") "Velocity at the inlet";
Real V2_n(unit = "m/s") "Normal velocity component at the outlet";
Real V2_t(unit = "m/s") "Velocity at the outlet";
Real H(unit = "m") "Net head";
Real H_watercolumn(unit = "mm of water") "Head of water column";
Real bhp(unit = "hp") "Required brake horse power";

//=================
//Equation Section 
equation 

//Multiplying r and b by 0.01 to convert cm to m
V1_n = (v)/(2*pi*r_1*b_1*0.0001);
V2_n = (v)/(2*pi*r_2*b_2*0.0001);
V1_t = 0; //Since alpha_1 = 0

V2_t = V2_n*tan(alpha_2*(pi/180)); 
//Multipying alpha_2 by (pi/180) to convert degree to rad

H = (omega/g)*(r_2*0.01*V2_t);
H_watercolumn = H*(Rho_air/Rho_water)*1000;
//Multiplying by 1000 to convert m to mm

bhp = Rho_air*g*v*H;

end Ex14_5;
//==================
