//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-14: Turbomachinery
//Example 14.6 Page 818
//Title: Preliminary Design of a Centrifugal Pump

model Ex14_6
extends Modelica.Constants;
extends Modelica.Math;

//=================
//Parameter Section
parameter Real g(unit = "m/s2") = 9.81 "Gravitational constant";
parameter Real v(unit = "m3/s") = 0.25 "Flow rate of liquid";
parameter Real b_1(unit = "mm") = 50 "Width of impeller inlet";
parameter Real b_2(unit = "mm") = 30 "Width of impeller outlet";
parameter Real r_1(unit = "mm") = 100 "Radius of impeller inlet";
parameter Real r_2(unit = "mm") = 180 "Radius of impeller outlet";
parameter Real H(unit = "m") = 14.5 "Net head";
parameter Real omega(unit = "rpm") = 1720 "Rotational speed of the impeller";


//Properties of refrigerent R-134a at T=20 C
parameter Real vf(unit = "m3/kg") =  0.0008157 "Specific  of refrigerent";


//=================
//Variable Section 
Real W_waterhorsepower(unit = "W") "Required water horsepower";
Real bhp(unit = "hp") "Brake horsepower";
Real beta_1(unit = "degree") "Blade inlet angle";
Real beta_2(unit = "degree") "Blade outlet angle";
Real V2_n(unit = "m/s") "Normal velocity component at the outlet";
Real V2_t(unit = "m/s") "Tangential velocity at the outlet";
Real Rho_r(unit "kg/m3") "Density of the referigirant";
Real omega_c(unit = "rps") "Rotational speed of the impeller";

//=================
//Equation Section 
equation 
Rho_r = 1/vf;
W_waterhorsepower = Rho_r*g*H*v;
bhp = W_waterhorsepower/745.7; 
//Dividing W_waterhorsepower to convert W to hp

omega_c = omega*2*pi/60; 
//Dividing omega by 60 to convert rpm to rps

//Multiplying r_2 and b_2 by 0.001 to convert mm to m
//Multiplying betaby (180/pi) to convert rad to degree
 
beta_1 = (atan(v/(2*pi*b_1*0.001*omega_c*(r_1*0.001)^2)))*(180/pi);
V2_t = (g*H)/(omega_c*r_2*0.001); 
V2_n = v/(2*pi*r_2*0.001*b_2*0.001);
beta_2 = (atan(V2_n/((omega_c*r_2*0.001)-(V2_t))))*(180/pi);

//Answer may slightly vary from book answer value due to round off. 

end Ex14_6;
//==================
