//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-14: Turbomachinery
//Example 14.7 Page 824
//Title: Calculation of Twist in an Airplane Propeller

model Ex14_7
extends Modelica.Constants;
extends Modelica.Math;

//=================
//Parameter Section
parameter Real omega(unit = "rpm") = 1700 "Speed of propeller";
parameter Real D_propeller(unit = "cm") = 34 "Overall diameter of the propeller";
parameter Real D_hub(unit = "cm") = 5.5 "Diameter of the hub";
parameter Real V_in(unit = "m/s") = 13.4 "Inlet velocity of the airplane";
parameter Real alpha(unit = "degree") = 14 "Angle of attack at every radius along the propeller blade";

//=================
//Variable Section 
Real theta_1(unit = "degree") "Pitch angle at root";
Real theta_2(unit = "degree") "Pitch angle at the tip";
Real r_propeller(unit = "m") "Radius of propeller";
Real r_hub(unit = "m") "Radius of hub";

//=================
//Equation Section 
equation
r_propeller = (D_propeller*0.01)/2;
r_hub = (D_hub*0.01)/2;
theta_1 = alpha + (atan((V_in/(omega*r_hub))*(1/(2*pi))*(60/1)))*(180/pi);
theta_2 = alpha + (atan((V_in/(omega*r_propeller))*(1/(2*pi))*(60/1)))*(180/pi);
//Multiplying by (180/pi) to convert rad to degree
//Multiplying by (60/2*pi) to convert omega from rpm to rps

end Ex14_7;
//==================
