//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-2: Properties of Fluids  
//Example 2.2  Page 43 
//Title: Danger of Cavitation in a Propeller

model Ex2_2
extends Modelica.Constants;

//=================
//parameter Section
parameter Real P_sat(unit = "kPa") = 2.34 "The saturation pressure of water at 20 celsius";
parameter Real P_t(unit = "kPa") = 2 "Pressure at the tip of propeller";
//Saturation Pressure is taken from Table 2-2 , Page No.42

//=================
//Variable Section 
Real Pv(unit = "kPa") "Vapour Pressure at given temperature"; 
String Analysis;

//=================
//Equation Section
equation 
Pv = P_sat;
if P_t < Pv then 
Analysis = "danger of cavitation for this propeller occurs";
else 
Analysis = "danger of cavitation for this propeller does not occur";
end if;

Modelica.Utilities.Streams.print(Analysis);

end Ex2_2;
//=================
