//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-2: Properties of fluids 
//Example 2.4 Page 51 
//Title: Mach Number of Air Entering a Diffuser 

package Ex2_4
model Ex2_4_a

//=================
//Parameter Section
parameter Real R(unit = "kJ/kg K") = 0.287 "Gas constant of air ";
parameter Real T(unit = "C") = 30 "Air temperature";
parameter Real k(unit = "-") = 1.4 "Specific heat ratio";
parameter Real V(unit = "m/s") = 200 "Speed of air";

//=================
//Variable Section 
Real c(unit = "m/s") "Speed of sound";
Real T_c(unit = "K") "Converted temperature from C to K";

//=================
//Equation Section 
equation 
T_c = T+273;
c= (k*R*T_c*1000)^(1/2);

end Ex2_4_a;

//==================
model Ex2_4_b
extends Ex2_4_a;

//===================
//Variable Section
Real Ma(unit = "-") "Mach Number";
String Flow;

//===================
//Equation Section
equation
Ma = V/c;

//Checking Flow Condition   
if Ma<1 then
Flow = "Flow at the diffuser inlet is subsonic";
else
Flow  = "Flow at the diffuser inlet is not subsonic";
end if;

Modelica.Utilities.Streams.print(Flow);    

end Ex2_4_b;
//====================
end Ex2_4;

//====================
