//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-2: Properties of Fluids  
//Example 2.5  Page 55 
//Title: Determining the Viscosity of a Fluid 

model Ex2_5
extends Modelica.Constants;

//=================
//Parameter Section
parameter Real l(unit = "cm") = 0.15 "Gap between two cylinders";
parameter Real T(unit = "N.m") = 1.8 "Torque";
parameter Real L(unit = "cm") = 40 "Length of the cylinder ";
parameter Real D(unit = "cm") = 12 "Outer diameter of inner cylinder ";
parameter Real n(unit = "rpm") = 300 "Number of revolutions per minute";

//=================
//Variable Section 
Real mu(unit = "N.s/m2") "Viscosity of fluid";
Real R(unit = "cm") "Radius of inner cylinder";

//=================
//Equation Section
equation 
R = D/2; 
//Converting diameter to radius 

mu=(T*l*0.01)/(4*pi^2*((R*0.01)^3)*(n/60)*(L*0.01));
//Multiplying by 0.01 to convert l,L,R from cm to m
//Dividing n by 60 to convert rpm to rps

end Ex2_5;
//=================
