//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-2: Properties of Fluids  
//Example 2.6  Page 60 
//Title: The Capillary Rise of Water in a Tube

model Ex2_6
extends Modelica.Math;

//=================
//Parameter Section
parameter Real T(unit = "C") = 20 "Temperature";
parameter Real sigma_s(unit = "N/m") = 0.073 "Surface tension of water at 20 C";
//Surface tension is taken from Table 2-4, Page No. 57

parameter Real phi(unit = "degree") = 0 "contact angle of water with glass";
//In atmospheric air, Contact angle of water with glass is nearly 0  

parameter Real Rho(unit = "kg/m3")=1000 "Density of water";
parameter Real g(unit = "m/s2") = 9.81 "Gravitational Constant";
parameter Real D(unit = "mm") = 0.6 "Diameter of glass tube";

//=================
//Variable Section 
Real R(unit = "m") "Radius of glass tube";
Real h(unit = "m") "Capillary rise of water"; 
Real h_C(unit = "cm") "Converted Capillary rise of water in cm"; 

//=================
//Equation Section
equation 
R = (D/2)*0.001; 
//Converting R from mm to m

h=((2*sigma_s)/(Rho*g*R))*cos(phi);

h_C=h*100; 
//Converting height from m to cm

end Ex2_6;
//=================
