//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-3: Pressure and Fluid Statics   
//Example 3.13  Page 113 
//Title: Rising of a Liquid During Rotation

model Ex3_13
extends Modelica.Constants;

//=================
//parameter Section
parameter Real D(unit = "cm") = 20  "Diameter of the vertical cylinder container";
parameter Real H(unit = "cm") = 60 "Height of the vertical cylinder container";
parameter Real h0(unit = "cm") = 50 "Original height of the liquid before rotation";
parameter Real g(unit = "m/s2") = 9.81 "Gravitational constant";

//=================
//Variable Section 
Real R(unit = "m") "Radius of vertical cylinder container";
Real omega(unit = "rad/s") "Maximum rotational speed of the container";
Real n(unit = "rpm") "Rotational speed of the container in terms of rpm";

//=================
//Equation Section
equation 
R = (D*0.01)/2 ; 
//Multiplying D by 0.01 to convert cm to m

omega = sqrt((4*g*(H-h0)*0.01)/(R^2)); 
//Multiplying H by 0.01 to convert cm to m

n =(omega / (2*pi))*60; 
//Multiplying by 60 to convert rps to rpm

end Ex3_13;
//=================
