//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-3: Pressure and Fluid Statics   
//Example 3.2  Page 83
//Title: Operation of a Hydraulic Jack

package Ex3_2
model Ex3_2_a

//=================
//Parameter Section
parameter Real A1(unit = "cm2") = 0.8 "Area-1 of piston";
parameter Real A2(unit = "m2") = 0.04 "Area-2 of piston";
parameter Real F2(unit = "N")= 13000 "Force required to hold the weight of the car";

//=================
//Variable Section 
Real F1_a(unit = "N") "Force required to hold the weight of the car when both piston is at same elevation";

//=================
//Equation Section
equation 
F1_a = F2*(A1*0.0001/A2); 
//Multiplying A1 by 0.0001 to convert cm2 to m2

end Ex3_2_a;


//=================

model Ex3_2_b
extends Ex3_2_a;

//=================
//Parameter Section
parameter Real SG(unit = "-") = 0.870 "Specific gravity of hydraulic oil";
parameter Real g(unit = "m/s2") = 9.807 "Gravitational constant";
parameter Real h(unit = "m") = 2 "Rise in height of car";

//=================
//Variable Section
Real F1_b(unit = "N") "Force required to hold the weight of car when it is lifted";
Real Rho(unit = "kg/m3") "Density of hydraulic oil";

//=================
//Equation Section
equation 
Rho = SG*1000;
F1_b = (F2*(A1*0.0001/A2))+(Rho*g*h*A1*0.0001); 
//Multiplying A1 by 0.0001 to convert cm2 to m2

end Ex3_2_b;

//=================

end Ex3_2;
//=================

