//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-3: Pressure and Fluid Statics   
//Example 3.7  Page 89 
//Title: Measuring Pressure with a Multifluid Manometer

model Ex3_7

//=================
//Parameter Section
parameter Real g(unit = "m/s2") = 9.81 "Gravitational constant";

//From Figure 3-24, Page No.90
parameter Real h1(unit = "m") = 0.1 "Height-1";
parameter Real h2(unit = "m") = 0.2 "Height-2";
parameter Real h3(unit = "m") = 0.35 "Height-3";
parameter Real Rho_w(unit = "kg/m3")= 1000 "Density of water";
parameter Real Rho_m(unit = "kg/m3")= 13600 "Density of mercury";
parameter Real Rho_o(unit = "kg/m3")= 850 "Density of oil";
parameter Real Patm(unit = "kPa") = 85.6 "Atmospheric pressure";

//=================
//Variable Section 
Real P1(unit = "kPa") "Air pressure in the tank";

//=================
//Equation Section
equation 
P1 = Patm + (g*(Rho_m*h3-Rho_o*h1-Rho_w*h2)/1000); 
//P1 is divided by 1000 to convert it to kPa

end Ex3_7;

//=================
