//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-4: Fluid Kinematics   
//Example 4.1  Page 139 
//Title: A Steady Two-Dimensional Velocity Field

package Ex4_1
model Ex4_1_a

//=================
//Parameter Section
parameter Real m1(unit = "-") = 0.5  "Variable 1 in vector form";
parameter Real m2(unit = "-") = 0.8  "Variable 2 in vector form";
parameter Real m3(unit = "-") = 1.5  "Variable 3 in vector form";
parameter Real m4(unit = "-") = -0.8 "Variable 4 in vector form";

/*Input given in vector form

V = (u,v) = (0.5+0.8x)i + (1.5-0.8y)j

*/

//=================
//Variable Section 
Real x(unit = "m") "Stagnation point-location-1";
Real y(unit = "m") "Stagnation point-location-2";

//=================
//Equation Section
equation 
//To find the stagnation point
m1 + m2*x = 0;
m3 + m4*y = 0;

end Ex4_1_a;

//=================

model Ex4_1_b
extends Ex4_1_a;

//=================
//Parameter Section

//Input data from question
parameter Real [5] x_array(each unit = "m") = {-2,-1,0,1,2} "Domain";
parameter Real [5] y_array(each unit = "m") = {1,2,3,4,5} "Domain";

//=================
//Variable Section 
Real [5] u(each unit = "m/s") "x-components of velocity";
Real [5] v(each unit = "m/s") "y-components of velocity";

//=================
//Equation Section
equation 
//To find the components of velocity and describing the flow field

for i in 1:5 loop
u[i] = m1 + m2*x_array[i];
v[i] = m3 + m4*y_array[i];
end for;

end Ex4_1_b;

//=================

end Ex4_1;

//=================
