//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-5: Bernoulli and Energy Equations   
//Example 5.12  Page 228
//Title:  Pumping Power and Frictional Heating in a Pump

package Ex5_12
model Ex5_12_a

//=================
//Parameter Section
parameter Real Rho_w(unit = "kg/L") = 1 "Density of water";
parameter Real V(unit = "L/s") = 50 "Volumetric flow rate";
parameter Real Eff_motor(unit = "%") = 90 "Efficiency of the motor";
parameter Real W_motor(unit = "kW") = 15 "Power drawed by motor"; 
parameter Real P1(unit = "kPa") = 100 "Absolute pressures at the inlet";
parameter Real P2(unit = "kPa") = 300 "Absolute pressures at the outlet";

//=================
//Variable Section 
Real m(unit = "kg/s") "Mass flow rate of water through the pump";
Real W_pump(unit = "kW") "Mechanical power that is delivered to the pump";
Real del_E_mech(unit = "kW") "Increase in the mechanical energy of the fluid";
Real Eff_pump(unit = "%") "Mechanical efficiency of the pump";

//=================
//Equation Section 
equation 
m = Rho_w*V;
W_pump = (Eff_motor/100)*W_motor;
del_E_mech = m*((P2-P1)/(Rho_w*10^3));
Eff_pump = (del_E_mech/W_pump)*100;

end Ex5_12_a;

//==================
model Ex5_12_b
extends Ex5_12_a;

//=================
//Parameter Section
parameter Real Cp(unit = " kJ/ kg.C") = 4.18 "Specific heat capacity of water";

//=================
//Variable Section 
Real E_mech_loss(unit = "kW") "Loss in mechanical energy";
Real del_T(unit = "C") "Temperature rise of water due to this mechanical inefficiency";

//=================
//Equation Section 
equation 
E_mech_loss = W_pump-del_E_mech;
del_T = E_mech_loss / (m*Cp);

end Ex5_12_b;
//==================

end Ex5_12;

//==================
