//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-5: Bernoulli and Energy Equations   
//Example 5.14  Page 230
//Title:  Fan Selection for Air Cooling of a Computer

package Ex5_14
model Ex5_14_a
extends Modelica.Constants;

//=================
//Parameter Section
parameter Real L(unit = "cm") = 12 "Length of computer case";
parameter Real H(unit = "cm") = 40 "Height of computer case";
parameter Real W(unit = "cm") = 40 "Width of computer case";
parameter Real Rho_a(unit = "kg/m3") = 1.2 "Density of air";
parameter Real VF(unit = "-") = 0.5 "Void fraction"; //Since half of the volume of the case is occupied by the components
parameter Real del_T(unit = "s") = 1 "Time period";
parameter Real D(unit = "cm") = 5 "Diameter of hole";
parameter Real Eff_FanMotor(unit = "%") = 30 "Efficiency of fan motor";
parameter Real alpha_2(unit = "-") = 1.1 "Kinetic energy correction factor at the outlet";

//=================
//Variable Section 
Real del_V_air(unit = "cm3") "Air volume in the computer case";
Real TV(unit = "cm3") "Total case volume";
Real V2(unit = "m3/s") "Volume flow rate of air";
Real m(unit = "kg/s") "Mass flow rate of air";
Real A(unit = "m2") "Cross-sectional area of the opening in the case";
Real V_avg(unit = "m/s") "Average air velocity through the outlet";
Real W_fan(unit = "W") "Power of fan";
Real W_elec(unit = "W") "Required electric power input to the fan";

//=================
//Equation Section 
equation 
TV = L*H*W;
del_V_air = VF*TV;
V2 = (del_V_air/del_T)*(0.01^3);
m = Rho_a*V2;
A = (pi/4)*((D*0.01)^2);
V_avg = V2/A;
W_fan = (m*alpha_2)*(V_avg^2/2);
W_elec = W_fan/(Eff_FanMotor/100);

end Ex5_14_a;

//=================
model Ex5_14_b
extends Ex5_14_a;

//=================
//Variable Section 
Real del_P(unit = "Pa") "Pressure rise across the fan";

//=================
//Equation Section 
equation 
del_P = (Rho_a*W_fan)/m;

end Ex5_14_b;
//=================

end Ex5_14;

//=================
