//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-6: Momentum Analysis of flow systems 
//Example 6.2 Page 261 
//Title: The Force to Hold a Deflector Elbow in Place

package Ex6_2
model Ex6_2_a

//=================
//Parameter Section
parameter Real m(unit = "kg/s") = 14 "Mass flow rate of water"; //m1=m2=m due to steady flow system
parameter Real Rho(unit = "kg/m3") = 1000 "Density of water";
parameter Real A1(unit = "cm2") = 113 "Cross-sectional area of the elbow at the inlet";
parameter Real A2(unit = "cm2") = 7 "Cross-sectional area of the elbow at the outlet";
parameter Real g(unit = "m/s2") = 9.81 "Gravitatinal constant";
parameter Real z1(unit = "m") = 0 "Elevation at the center of the inlet cross section as the reference level";
parameter Real z2(unit = "cm") = 30 "Elevation difference between the centers of the outlet and the inlet";
parameter Real P2(unit = "kPa") = 101.325 "Pressure at outlet"; //atmospheric pressure 

//=================
//Variable Section 
Real V1(unit = "m/s") "Inlet velocity of water";
Real V2(unit = "m/s") "Outlet velocity of water";
Real P1_gage(unit = "kPa") "Gage pressure at the center of the inlet of the elbow";

//=================
//Equation Section
equation 
V1 = m/(Rho*A1*0.0001);
V2 = m/(Rho*A2*0.0001);

//Since P2=Patm; P1-P_atm = P1_gage
P1_gage= (((Rho*g)*(((V2^2-V1^2)/(2*g))+(z2*0.01)-z1))*(1/1000));

end Ex6_2_a;
//=================
model Ex6_2_b
extends Ex6_2_a;
extends Modelica.Math;
extends Modelica.Constants;

//=================
//Parameter Section
parameter Real beta(unit = "-") = 1.03 "Momentum-flux correction factor"; //beta1=beta2=beta 
parameter Real theta(unit = "degree") = 30 "Angle made by elbow"; //From Figure 6-20

//=================
//Variable Section 
Real FR_x(unit = "N") "x-components of the anchoring force of the elbow ";
Real FR_z(unit = "N") "z-components of the anchoring force of the elbow ";

//=================
//Equation Section
equation 
FR_x = beta*m*(V2*cos(theta*(pi/180))-V1)-(P1_gage*1000*A1*(0.01^2)); 
//Multiplying A1 by 0.01^2 to convert cm2 to m2
//Multiplying theta by (pi/180) to convert degree to radian
FR_z = beta*m*V2*sin(theta*(pi/180));

end Ex6_2_b;

//=================

end Ex6_2;

//=================
