//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-6: Momentum Analysis of flow systems 
//Example 6.3 Page 263 
//Title: The Force to Hold a Reversing Elbow in Place

model Ex6_3

//=================
//Parameter Section
parameter Real beta(unit = "-") = 1.03 "Momentum-flux correction factor"; 
parameter Real V1(unit = "m/s") = 1.24 "Inlet velocity of water"; //From solution 6.2
parameter Real V2(unit = "m/s") = 20 "Outlet velocity of water"; //From solution 6.2
parameter Real m(unit = "kg/s") = 14 "Mass flow rate of water";
parameter Real A1(unit = "cm2") = 113 "Cross-sectional area of the elbow at the inlet";

//From Ex6_2_a solution
parameter Real P1(unit = "N/m2") = 202200 "Gage pressure at reference 1";

//=================
//Variable Section 
Real FR_x(unit = "N") "Anchoring force needed to hold the elbow in place";

//=================
//Equation Section
equation 
FR_x = (-beta*m*(V2+V1))-(P1*A1*0.0001);

end Ex6_3;
//=================
