//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-6: Momentum Analysis of flow systems 
//Example 6.4 Page 263 
//Title: Water Jet Striking a Moving Cart

package Ex6_4
model Ex6_4_a

//=================
//Parameter Section
parameter Real V_jet(unit = "m/s") = 35 "Velocity of the jet";
parameter Real V_cart(unit = "m/s") = 10 "Velocity of the cart";
parameter Real m_jet(unit = "kg/s") = 30 "Mass flow rate of water through the stationary nozzle";

//=================
//Variable Section 
Real V_r(unit = "m/s") "Relative velocity between the cart and the jet";
Real m_r(unit = "kg/s") "Mass flow rate of water striking the cart";
Real F_brake(unit = "N") "Force that needs to be applied by the brakes";

//=================
//Equation Section
equation 
V_r = V_jet-V_cart;
m_r=(V_r/V_jet)*m_jet;
F_brake = -(m_r*V_r); 
//The -ve sign indicates that the braking force acts in the opposite direction to motion

end Ex6_4_a;
//=================
model Ex6_4_b
extends Ex6_4_a;

//=================
//Variable Section 
Real W(unit = "kW") "Power wasted by the brakes";
Real W_gen(unit = "kW") "Maximum amount of power that could ideally be generated";
Real F(unit = "N") "Force that needs to be applied by the brakes";

//=================
//Equation Section
equation 
F = -(F_brake);
W = (F*V_cart)/1000;
//Dividing W by 1000 to convert W to kW
W_gen = W; 
//As the cart velocity is maintained constant

end Ex6_4_b;

//=================
model Ex6_4_c
extends Ex6_4_b;
extends Ex6_4_a;

//=================
//Parameter Section
parameter Real m_cart(unit = "kg") = 400 "Mass of the cart";

//=================
//Variable Section 
Real a(unit = "m/s2") "Acceleration of the cart when the water first strikes it";

//=================
//Equation Section
equation 
a = F/m_cart;

end Ex6_4_c;
//=================

end Ex6_4;

//=================
