//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-6: Momentum Analysis of flow systems 
//Example 6.5 Page 265 
//Title: Power Generation and Wind Loading of a Wind Turbine

package Ex6_5
model Ex6_5_a
extends Modelica.Constants;

//=================
//Parameter Section
parameter Real D(unit = "ft") = 30 "Diameter of the blade span";
parameter Real WS(unit = "mph") = 7 "Cut-in wind speed";
parameter Real Rho_1(unit = "lbm/ft3") = 0.076 "Density of air";
parameter Real W_act(unit = "kW") = 0.4 "Actual electric power generated by the turbine";

//=================
//Variable Section 
Real V_1(unit = "ft/s") "Inlet wind veolocity";
Real m(unit = "lbm/s") "Mass flow rate of air";
Real W_max(unit = "kW") "Maximum electric power generated by the turbine";
Real Eff(unit = "%") "Turbine–generator efficiency";
Real A_1(unit = "ft2") "Area of the blade span";

//=================
//Equation Section
equation 
V_1 = WS*1.4667; 
//WS Multiplied by 1.4667 to convert mph to ft/s

A_1 = pi/4*(D^2);
m = Rho_1*V_1*A_1;
W_max = m*(V_1^2/2)*(1/32.2)*(1/737.56); 
//Converting W_max from W to kW

Eff = (W_act/W_max)*100;

end Ex6_5_a;

//=================
model Ex6_5_b
extends Ex6_5_a;

//=================
//Variable Section 
Real V_2(unit = "ft/s") "Outlet wind velocity";
Real FR(unit = "lbf") "Horizontal force exerted by the wind";
Real F_mast(unit = "lbf") "Horizontal force exerted by the wind on the mast";
Real W_act_b(unit = "kW") "Power generation when wind velocity is doubled"; 
Real F_mast_b(unit = "lbf") "Horizontal force exerted by the wind on the mast when wind velocity is doubled";

//=================
//Equation Section
equation 
V_2 = V_1*(sqrt(1-(Eff/100)));
FR = (m*(V_2-V_1))/32.2;
F_mast = -FR;

//Case 2 - Doubling the wind velocity to 14 mph
W_act_b = (2^3)*W_act; 
//Power generated is proportional to V^3

F_mast_b = (2^2)*F_mast; 
//The force exerted by the wind on the support mast is proportional to V^2

end Ex6_5_b;
//=================

end Ex6_5;

//=================
