//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-7: Dimensional Analysis and Modeling 
//Example 7.4 Page 304 
//Title: Extrapolation of Nondimensionalized Data

package Ex7_4
model Ex7_4_a
extends Modelica.Math;
extends Modelica.Constants;

//=================
//Parameter Section
parameter Real IS(unit = "m/s") = 21 "Initial speed of the baseball";
parameter Real A(unit = "degree") = 5 "Angle made by the baseball when it is thrown";
parameter Real z0(unit = "m") = 2 "Position of baseball above the moon surface";
parameter Real g_moon(unit = "m/s2") = 1.63 "Gravitational constant on the moon";

//Determined from Figure 7–13, Page No.303
parameter Real t_s(unit = "s") = 2.75 "Estimated time in terms of dimensionless variables";

//=================
//Variable Section 
Real w0(unit = "m/s") "Vertical component of initial speed";
Real Fr(unit = "-") "Froude number"; //Fr^2
Real t_a(unit = "s") "Estimated time to strike the ground";

//=================
//Equation Section
equation 
w0 = IS*(sin(A*pi/180)); 
//Multiplying by pi/180 to convert degree to radian

Fr = w0^2/(g_moon*z0);
t_a = (t_s*z0)/w0;

end Ex7_4_a;

//=================
model Ex7_4_b
extends Ex7_4_a;

//=================
//Variable Section 
Real t_b(unit = "s") "Exact time to strike the ground";

//=================
//Equation Section
equation 
t_b = (w0+sqrt((w0^2)+(2*z0*g_moon)))/(g_moon);

end Ex7_4_b;

//=================

end Ex7_4;

//=================
